*********************************************
* Rdisk
*  A driver for a Ram disk!
* Modified for os9l1 emulator by Soren Roug 2001
*

         nam Rdisk
         ttl A Device Driver for a RAM Disk

         ifp1
         use os9defs
         use rbfdefs
         endc

***********************
* Edition History

*  #   date    Comments
* -- -------- ----------------------------------------------

Revision equ 1
NumDrvs  set 1 Number of drives

         org Drvbeg
         rmb NumDrvs*DrvMem
RAMSTA   equ .

         mod RAMEND,RAMNAM,Drivr+Objct,Reent+Revision,RAMENT,RAMSTA
RAMNAM   fcs /Rdisk/

RAMENT   lbra INIT
         lbra READ
         lbra WRITE
         lbra GETSTA
         lbra PUTSTA
         lbra TERM

*****************************
* INIT
*  Set up the ramdisk

INIT     lda #NumDrvs Set no drives to 1
         sta V.NDRV,U
         lda #$FF         non-zero value
         leax DrvBeg,U    X=Start of drive table
initdrv
         sta DD.Tot,X     write in non-zero values
         sta V.Trak,X
         leax DrvMem,x
         deca             loop through drives
         bne initdrv
         clrb
INITXIT  rts

*****************************
* READ
*  read a sector from disk
*  Entry: U = Static Storage
*         Y = Path Descriptor
*         B = MSB of LSN
*         X = LSB's of LSN
*  Exit: 256 byte sector in PD.BUF buffer
*
READ     lda V.PORT,U
         clrb
         rts

*****************************
* WRITE
*  Write a sector to disk
* Entry: U = Static Storage
*        Y = Path Descriptor
*        B = MSB of LSN
*        X = LSB's of LSN
*        PD.Buf = Sector to write
*
WRITE    lda #0
         sta V.PORT,U
         clrb
WRIT99   rts

**************************
* GETSTA
*  get device status
*
GETSTA
Unknown  comb
         ldb #E$UnkSVC
         rts

**************************
* PUTSTA
*  Set device Status
*
PUTSTA   cmpb #SS.Reset
         beq PUTSTA90
         cmpb #SS.WTrk
         bne Unknown

PUTSTA90 clrb
         rts

*****************************
* TERM
*  terminate Driver
*
TERM     clrb
         rts

         emod
RAMEND   equ *

