/*
 * BINEX:  translate binary file to Motorola S-record format
 */
#include <stdio.h>
#include <string.h>

main(int argc,char **argv)
{
    unsigned char buf[64];
    int offset,nsize;
    int execbase=-1;
    unsigned char *lptr;
    int sum,c;
    extern char *optarg;
    extern int optind, opterr, optopt;
    FILE *infp,*outfp;

    outfp = stdout;

    if(argc == 1)
    {
        fprintf(stderr,"Usage: exbin [-a address] [-o outfile] [-x exec] infile ...\n");
	exit(0);
    }

    while(1)
    {
	c = getopt(argc, argv, "a:o:x:");
	if (c == -1)
	    break;
     
	switch (c)
	{
	case 'o':
	     outfp = fopen(optarg,"w");
	     break;
	case 'a':
	     offset = strtol(optarg, (char **)NULL, 16);
	     break;
	case 'x':
	     execbase = strtol(optarg, (char **)NULL, 16);
	     break;
	}
    }

    while (optind < argc)
    {
	if(!(infp = fopen(argv[optind++],"r")))
	    continue;


	if(lptr = strchr(argv[optind -1],'\n'))
	    *lptr = '\0';
	nsize = strlen(argv[optind -1]);
	sum = nsize + 3;
	fprintf(outfp,"S0%02X0000",nsize+3);
	for(lptr = argv[optind -1];*lptr != '\0' ; lptr++)
	{
	    fprintf(outfp,"%02X",*lptr);
	    sum += *lptr;
	}
	fprintf(outfp,"%02X\n",~sum & 0xff);
	while((nsize = fread(buf,1,32,infp)) > 0)
	{
	    sum = nsize + 3 + (offset >> 8) + (offset & 0xff);
	    fprintf(outfp,"S1%02X%04X", nsize+3, offset);
	    for(lptr = buf; lptr < (buf + nsize); lptr++)
	    {
		sum += *lptr;
		fprintf(outfp,"%02X",*lptr);
	    }
	    fprintf(outfp,"%02X\n",~sum & 0xff);
	    offset += nsize;
	    offset &= 0xffff;
	}
	fclose(infp);
    }
    nsize = 0;
    sum = nsize + 3 + (execbase >> 8) + (execbase & 0xff);
    if(execbase != -1)
	fprintf(outfp,"S9%02X%04X%02X\n",nsize+3,execbase,~sum & 0xff);
    exit(0);
}
