/*
    (c) 2001 Soren Roug

    This file is part of os-nine.

    os-nine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//	v6809.cc - Virtual 6809
// The idea behind this program is to have virtual devices that are
// easy to support from OS9
//

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "mc6809_X.h"
#include "mc6850.h"

#ifdef __unix
#include <unistd.h>
#endif

#ifdef __osf__
extern "C" unsigned int alarm(unsigned int);
#endif

//#ifndef sun
//typedef void SIG_FUNC_TYP(int);
//typedef SIG_FUNC_TYPE *SIG_FP;
//#endif

class sys : virtual public mc6809_X {

protected:

	virtual Byte			 read(Word);
	virtual void			 write(Word, Byte);

protected:

		mc6850			 uart;

} sys;

Byte sys::read(Word addr)
{
	Byte		ret = 0;

	if ((addr & 0xfffe) == 0xff40) {
		ret = uart.read(addr);
	} else {
		ret = mc6809_X::read(addr);
	}

	return ret;
}

void sys::write(Word addr, Byte x)
{
	if ((addr & 0xfffe) == 0xff40) {
		uart.write(addr, x);
	} else {
		mc6809_X::write(addr, x);
	}
}

#ifdef SIGALRM
#ifdef sun
void update(int, ...)
#else
void update(int)
#endif
{
	sys.status();
	(void)signal(SIGALRM, update);
	alarm(1);
}
#endif // SIGALRM

int main(int argc, char *argv[])
{
	if (argc != 2) {
		fprintf(stderr, "usage: %s <hexfile>\n",argv[0]);
		return EXIT_FAILURE;
	}

/*
	(void)signal(SIGINT, SIG_IGN);
*/
#ifdef SIGALRM
	(void)signal(SIGALRM, update);
	alarm(1);
#endif

	sys.load_srecord(argv[1]);
	sys.run();

	return EXIT_SUCCESS;
}
