/*
    (c) 2001 Soren Roug
 
    This file is part of Osnine.
 
    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
    $Id: devdrvr.cpp 56 2011-11-30 21:28:54Z roug $
*/
#include <cstring>
using namespace std;
#include <sys/types.h>
#include "devdrvr.h"
#include "mc6809.h"
#include "os9krnl.h"
#include "errcodes.h"

/*
 * The file descriptor class contains the resources necessary for
 * the open file. It also has a pointer to the driver.
 */
fdes::fdes()
{
    usecount=0;
}

int fdes::close()
{
    usecount--;
    return 0;
}

void fdes::getstatus(os9 *cpu)
{
    cpu->sys_error(E_UnkSvc);
    return;
}

void fdes::setstatus(os9 *cpu)
{
    cpu->sys_error(E_UnkSvc);
    return;
}

int fdes::seek(int offset)
{
    return -1;
}

/*
 * The devdrvr class is a base class for virtual devices
 * The methods expect pathnames that are relative to the mount pount
 * and with out leading slash.
 */
devdrvr::devdrvr(const char *mntpnt)
{
    mntpoint = new char[strlen(mntpnt)+1];
    strcpy(mntpoint,mntpnt);
}

/*
 * Not possible
 */
fdes *devdrvr::open(const char *path,int mode,int create)
{
    return (fdes*)0;
}

/*
 * Not possible
 */
int devdrvr::close(fdes *)
{
    return 0;
}

/*
 * Not possible
 * 0 = OK, Not 0 means error code
 */
int devdrvr::makdir(char *path,int mode)
{
    return E_BMode;
}

/*
 * Not possible
 * 0 = OK, Not 0 means error code
 */
int devdrvr::chdir(char *path)
{
    return E_BMode;
}
//
// The NULL device driver.
// Is expected to be invoked as /null and will do the same as UNIX /dev/null

devnull::devnull(const char *mntpnt) : devdrvr(mntpnt)
{
}

fdes *devnull::open(const char *path,int mode,int create)
{
    return new fdnull;
}
