/*
    (c) 2001-2011 Soren Roug
 
    This file is part of Osnine.
 
    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "typedefs.h"

class devdrvr;  // Forward declaration

class os9;  // forward declaration
/**
 * The file descriptor class contains the resources necessary for
 * the open file. It also has a pointer to the driver.
 *
 * The actual data are in the derived classes
 */
class fdes {
public:
    devdrvr *driver;
    int usecount;
    int errorcode;
    fdes();
    virtual int close();
    virtual int read(Byte *,int) = 0;
    virtual int readln(Byte *,int) = 0;
    virtual void getstatus(os9 *);
    virtual void setstatus(os9 *);
    virtual int seek(int);
    virtual int write(Byte *,int) = 0;
    virtual int writeln(Byte *,int) = 0;
};

/**
 * The devdrvr class is a base class for virtual devices.
 * The methods expect pathnames that are relative to the mount pount
 * and without leading slash.
 */
class devdrvr {
public:
    static char *type;
    char *mntpoint;
    int errorcode;

    devdrvr(const char *);                 // Constructor
    virtual fdes *open(const char *,int,int);
    virtual int makdir(char *,int);
    virtual int chdir(char *);
    virtual int close(fdes *);
    virtual int delfile(char *) { return 203; };
};

/**
 * Null file descriptor. All reads return nothing.
 */
class fdnull : public fdes  {
public:
    virtual int read(Byte *buf,int len) { return 0; }
    virtual int readln(Byte * buf,int len)  { return 0; }
    virtual int write(Byte *buf,int len) { return len; }
    virtual int writeln(Byte *buf,int len) { return len; }
};


/**
 * Corresponds to /dev/null in UNIX
 */
class devnull : public devdrvr {
public:
    devnull(const char *);                 // Constructor
    fdes *open(const char *,int,int);
};

