/*
    (c) 2001 Soren Roug
 
    This file is part of Osnine.
 
    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
// The devdrvr class is a base class for virtual devices
// The methods expect pathnames that are relative to the mount pount
// and with out leading slash.

class devunix: public devdrvr {
public:
    char *unixdir;

    devunix(const char *, const char *);
    fdes *open(const char *,int,int);
    fdes *open(FILE*);
    int makdir(char *,int);
    int chdir (char *);
    int delfile(char *);
};

class fdunix: public fdes {
public:
    FILE *fp;
    virtual ~fdunix();
    fdunix();
    int close();
    int read(Byte *,int);
    int readln(Byte *,int);
    int write(Byte *,int);
    int writeln(Byte *,int);
    int seek(int);
    void getstatus (os9 *);
    void setstatus (os9 *);
};

class devterm: public devdrvr {
public:
    const char *device; /* The UNIX device it coresponds to -- like /dev/tty */

    devterm(const char *, const char *);
    fdes *open(const char *,int,int);
    fdes *open(FILE*);
};

class fdterm: public fdes {
public:
    FILE *fp;
    virtual ~fdterm();
    fdterm();
    fdterm(FILE *);
    int close();
    int read(Byte *,int);
    int readln(Byte *,int);
    int write(Byte *,int);
    int writeln(Byte *,int);
    int seek(int);
    void getstatus (os9 *);
    void setstatus (os9 *);
};

/**
 * Implementation of OS9 pipes.
 */
class devpipe: public devdrvr {
public:
    devpipe(const char *, const char *);
    fdes *open(const char *,int,int);
    fdes *open(FILE*);
};

/**
 * Pipe as file descriptor.
 */
class fdpipe: public fdes {
public:
    int filedes[2];
    FILE *ifp;
    virtual ~fdpipe();
    fdpipe();
    int close();
    int read(Byte *,int);
    int readln(Byte *,int);
    int write(Byte *,int);
    int writeln(Byte *,int);
    void getstatus (os9 *);
    void setstatus (os9 *);
};
