// InstructionsTest.h
#ifndef INSTRUCTIONSTEST_H
#define INSTRUCTIONSTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include "mc6809.h"

class InstructionsTest : public CPPUNIT_NS::TestFixture
{
  CPPUNIT_TEST_SUITE( InstructionsTest );
  CPPUNIT_TEST( testBRABackward );
  CPPUNIT_TEST( testBRAForward );
  CPPUNIT_TEST( testCMP );
  CPPUNIT_TEST( testJSR );
  CPPUNIT_TEST( testLDB );
  CPPUNIT_TEST( testLDD );
  CPPUNIT_TEST( testLEAX_PCR );
  CPPUNIT_TEST( testLSL );
  CPPUNIT_TEST( testNEG );
  CPPUNIT_TEST( testPULS );
  CPPUNIT_TEST( testTST );
  CPPUNIT_TEST_SUITE_END();

private:
  mc6809 *myTestCPU;
public:
  void setUp();
  void tearDown();

  void testBRABackward();
  void testBRAForward();
  void testCMP();
  void testJSR();
  void testLDB();
  void testLDD();
  void testLEAX_PCR();
  void testLSL();
  void testNEG();
  void testPULS();
  void testTST();
  void loadProg(Byte *, int);
    
};

#endif  // INSTRUCTIONSTEST_H
