/*
    (c) 2001-2005 Soren Roug

    This file is part of Osnine.

    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
 * This program is a unit-test of negate opcode in the 6809 CPU
 */

#include <cppunit/config/SourcePrefix.h>
#include "NegateTest.h"
#include "typedefs.h"
#include "misc.h"
#include <stdio.h>

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( NegateTest );


void 
NegateTest::setUp()
{
}


void 
NegateTest::tearDown()
{
}


union {
        Byte                    all;    // Condition code register
        struct {
                Byte            e : 1;  // Entire
                Byte            f : 1;  // FIRQ disable
                Byte            h : 1;  // Half carry
                Byte            i : 1;  // IRQ disable
                Byte            n : 1;  // Negative
                Byte            z : 1;  // Zero
                Byte            v : 1;  // Overflow
                Byte            c : 1;  // Carry
        } bit;
} cc;

// Negate with algorithm A
Byte help_nega(Byte x)
{
        cc.bit.v = (x == 0x80);
        {
                Word    t = (Word)((~x) & 0xff) + 1;
                cc.bit.c = btst(t, 8); // Set carry if bit 8 (base 0) is 1
                x = t & 0xff;
        }

        cc.bit.n = btst(x, 7);
        cc.bit.z = !x;
        return x;
}

// Negate with algorithm B
Byte help_negb(Byte x)
{
        cc.bit.v = (x == 0x80); // If x == 0x80 then set overflow
        {
                Word    t = (Word)((~x) & 0xff) + 1;
                x = t & 0xff;
        }

        cc.bit.n = btst(x, 7);
        cc.bit.z = !x;
        cc.bit.c = (x != 0);  // Set carry if result != 0
        return x;
}

void
NegateTest::testNeg()
{
    Byte x;

    cc.all = 0;
    CPPUNIT_ASSERT_EQUAL( 0, (int)help_nega(0) ); // Negate 0 - algorithm A
    CPPUNIT_ASSERT_EQUAL( 1, (int)cc.bit.c );
    cc.all = 0;
    CPPUNIT_ASSERT_EQUAL( 0, (int)help_negb(0) ); // Negate 0 - algorithm B
    CPPUNIT_ASSERT_EQUAL( 0, (int)cc.bit.c );
    cc.all = 0;
    CPPUNIT_ASSERT_EQUAL( 0xff, (int)help_nega(1) ); //Negate 1 = -1 = 0xff - algorithm A
    CPPUNIT_ASSERT_EQUAL( 0, (int)cc.bit.c );
    cc.all = 0;
    CPPUNIT_ASSERT_EQUAL( 0xff, (int)help_nega(1) ); //Negate 1 = -1 = 0xff - algorithm B
    CPPUNIT_ASSERT_EQUAL( 0, (int)cc.bit.c );
}
