/*
    (c) 2001-2005 Soren Roug

    This file is part of Osnine.

    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
 * This program is a unit-test of system calls in os9
 */

#include <cppunit/config/SourcePrefix.h>
#include "SyscallTest.h"
#include "typedefs.h"
#include "misc.h"
#include <stdio.h>

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( SyscallTest );

void 
SyscallTest::setUp()
{
    myTestOs = new os9();
}


void 
SyscallTest::tearDown()
{
}



/**
 * The example shown in the OS-9 System Programmer's Manual
 */
void
SyscallTest::testF_PRSNAM1()
{
    Byte pathname[] = "/D0/FILE";

    loadProg(pathname, sizeof pathname);
    myTestOs->x = 0x100;
    myTestOs->f_prsnam();
    CPPUNIT_ASSERT_EQUAL( 0x101, (int)myTestOs->x );
    CPPUNIT_ASSERT_EQUAL( 0x103, (int)myTestOs->y );
    CPPUNIT_ASSERT_EQUAL( 2, (int)myTestOs->b );

}

/**
 * Parse Hello world, the way the echo program sees it.
 */
void
SyscallTest::testF_PRSNAM2()
{
    Byte pathname[] = "Hello world\r";

    loadProg(pathname, sizeof pathname);
    myTestOs->x = 0x100;
    myTestOs->f_prsnam();
    // Expected: X -> 'H', Y -> ' ' and B = Y-X
    CPPUNIT_ASSERT_EQUAL( 0x100, (int)myTestOs->x );
    CPPUNIT_ASSERT_EQUAL( 0x105, (int)myTestOs->y );
    CPPUNIT_ASSERT_EQUAL( 5, (int)myTestOs->b );

    // Deal with the space. Must increment x with one
    myTestOs->x = 0x105;
    myTestOs->f_prsnam();
    CPPUNIT_ASSERT_EQUAL( 0x106, (int)myTestOs->x );
    CPPUNIT_ASSERT_EQUAL( 0x105, (int)myTestOs->y );
    CPPUNIT_ASSERT_EQUAL( (int)E_BNam, (int)myTestOs->b );
    // Parse the 'world'
    myTestOs->f_prsnam();
    CPPUNIT_ASSERT_EQUAL( 0x106, (int)myTestOs->x );
    CPPUNIT_ASSERT_EQUAL( 0x10B, (int)myTestOs->y );
    CPPUNIT_ASSERT_EQUAL( 5, (int)myTestOs->b );
}

/**
 * Load some data in to 0x100 and up.
 */
void 
SyscallTest::loadProg(Byte *instructions, int arraySize)
{
    Word respc;

    for (int a = 0; a < arraySize; a++) {
        myTestOs->write((Word)a + 0x100, instructions[a]);
    }
}

/*
 * Test the allocation of 60-byte process/path descriptors
 */
void
SyscallTest::testF_ALL64()
{
    int expected_y[] = { 0xf940,  0xf980, 0xf9c0, 0xf800, 0xf840, 0xf880, 0xf8c0, 0xf700 };

    myTestOs->x = 0;
    for(int i = 0; i < 8; i++) {
        myTestOs->f_all64();
        CPPUNIT_ASSERT_EQUAL(0xf900, (int) myTestOs->x);
        CPPUNIT_ASSERT_EQUAL(expected_y[i], (int) myTestOs->y);
        CPPUNIT_ASSERT_EQUAL(i + 1, (int) myTestOs->a);
        myTestOs->write(myTestOs->y, 1);  // Make the page dirty
    }
}

