// SyscallTest.h
#ifndef SYSCALLTEST_H
#define SYSCALLTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include "mc6809.h"
#include "devdrvr.h"
#include "devunix.h"
#include "os9krnl.h"
#include "errcodes.h"

class SyscallTest : public CPPUNIT_NS::TestFixture
{
  CPPUNIT_TEST_SUITE( SyscallTest );
  CPPUNIT_TEST( testF_PRSNAM1 );
  CPPUNIT_TEST( testF_PRSNAM2 );
  CPPUNIT_TEST( testF_ALL64 );
  CPPUNIT_TEST_SUITE_END();

private:
  os9 *myTestOs;

public:
  void setUp();
  void tearDown();

  void testF_PRSNAM1();
  void testF_PRSNAM2();
  void testF_ALL64();
private:
  void loadProg(Byte *, int);
    
};

#endif  // SYSCALLTEST_H
