/*
    (c) 2001-2003 Soren Roug

    This file is part of Osnine.

    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Os-nine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Os-nine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const int NumPaths = 16; // Whatever _NFILE is set to in os9's stdio.h
const int DefIOSiz = 12;
const int max_devs = 64;
const int max_pids = 32;
const int bitmapstart = 0x200; /* Start of memory bitmap */

typedef Byte OS9Pid_t;
typedef Word OS9Uid_t;
/*
 * Process descriptor
 *
 * This structure does not necesarily match the structure used in OS9,
 * except to make 'PROCS' work. (Uses P_ID, P_PagCnt, P_User, P_Queue etc.)
 */
const int p_ID = 0; /* 1 Process ID */
const int p_PID = 1; /* 1 Parent's ID */
const int p_SID = 2; /* 1 Sibling's ID */
const int p_CID = 3; /* 1 Child's ID */
const int p_SP = 4; /* 2 Stack ptr */
const int p_CHAP = 6; /* 1 process chapter number */
const int p_ADDR = 7; /* 1 user address beginning page number */
const int p_PagCnt = 8; /* 1 Memory Page Count */
const int p_User = 9; /* 2 User Index */
const int p_Prior = 11; /* 1 Priority */
const int p_Age = 12; /* 1 Age */
const int p_State = 13; /* 1 Status */
const int p_Queue = 14; /* 2 Queue Link (Process ptr) */
const int p_IOQP = 16; /* 1 Previous I/O Queue Link (Process ID) */
const int p_IOQN = 17; /* 1 Next     I/O Queue Link (Process ID) */
const int p_PModul = 18; /* 2 Primary Module */
const int p_SWI = 20; /* 2 SWI Entry Point */
const int p_SWI2 = 22; /* 2 SWI2 Entry Point */
const int p_SWI3 = 24; /* 2 SWI3 Entry Point */
const int p_DIO = 26; /* default I/O ptrs */
const int p_PATH = 38; /* I/O path table */
const int p_Signal = 54; /* 1 Signal Code */
const int p_SigVec = 55; /* 2 Signal Intercept Vector */
const int p_SigDat = 57; /* 2 Signal Intercept Data Address */

/*
 * Locations of page 0 variables
 */
const int D_FMBM   = 32; /* Free memory bit map pointers */
const int D_FMBME  = 34;
const int D_MLIM   = 36; /* Memory limit */
const int D_MDir   = 38; /* Module directory */
const int D_MDirE  = 40;
const int D_Init   = 42; /* Rom base address */
const int D_SWI3   = 44; /* 2 Swi3 vector */
const int D_SWI2   = 46; /* 2 Swi2 vector */
const int D_FIRQ   = 48; /* 2 Firq vector */
const int D_IRQ    = 50; /* 2 Irq vector */
const int D_SWI    = 52; /* 2 Swi vector */
const int D_NMI    = 54; /* 2 Nmi vector */
const int D_SvcIRQ = 56; /* 2 Interrupt service entry */
const int D_Poll   = 58; /* 2 Interrupt polling routine */
const int D_UsrIRQ = 60; /* 2 User irq routine */
const int D_SysIRQ = 62; /* 2 System irq routine */
const int D_UsrSvc = 64; /* 2 User service request routine */
const int D_SysSvc = 66; /* 2 System service request routine */
const int D_UsrDis = 68; /* 2 User service request dispatch table */
const int D_SysDis = 70; /* 2 System service request dispatch table */
const int D_Slice  = 72; /* 1 Process time slice count */
const int D_PrcDBT = 73; /* 2 Process descriptor block address */
const int D_Proc   = 75; /* 2 Process descriptor address */
const int D_AProcQ = 77; /* 2 Active process queue */
const int D_WProcQ = 79; /* 2 Waiting process queue */
const int D_SProcQ = 81; /* 2 Sleeping process queue */


/**
 * Simulation of the OS9 kernel. The system calls are added as SWI2 instructions.
 */
class os9 : virtual public mc6809 {
private:
        fdes *paths[NumPaths];
        char cxd[1024]; // Execution directory, typically /d0/CMDS
        char cwd[1024]; // Working directory
        char *sys_dev;	// System device - as known from init module
        int uppermem; // Absolute values
        int lowermem;
        devdrvr *devices[max_devs]; // devices, typically /d0,/h0 etc.
        int dev_end;
        pid_t pids[max_pids]; // Mapping of Proces identifiers
        int pid_end;
        int debug_syscall;

public:
        void loadmodule(const char *,const char *);
        void copytomemory(Word,Byte *);
        void setdebugcalls(int);
        int sys_error(Byte);
        int error_occurred();
        void next_proc();   // Switch to next runnable process

// Public constructor and destructor

        os9();
        ~os9();

protected:
        void swi2();

public:
// USER-MODE REQUESTS
        void f_allbit();
        void f_chain();
        void i_chgdir();
        void f_crc();
        void f_delbit();
        void f_exit();
        void f_fork();
        void f_id();
        void f_link();
        void f_load();
        void f_mem();
        void f_perr();
        void f_prsnam();
        void f_schbit();
        void f_sleep();
        void f_time();
        void f_unlink();
        void f_wait();
// SYSTEM PRIVILEGED REQUESTS
        void f_all64();
        void f_ret64();
        void f_srqmem();
        void f_srtmem();
// INPUT/OUTPUT REQUESTS
        void i_close();
        void i_dup();
        void i_getstt();
        void i_mdir();
        void i_open(int);
        void i_rdln();
        void i_read();
        void i_seek();
        void i_setstt();
        void i_wrln();
        void i_write();
        void i_deletex(int);
private:
        void loadrcfile();
        char *findpathseg(char *, char *);
        char *findpath(char *,bool );
        Word getpath(Byte*,Byte *,int);
        devdrvr *find_device(Byte *);
        Byte *find_os9path(Byte *);
        void mount_allunix(void);
        int os9strcmp(Word,Word);
        // Process housekeeping
        void init_proc();
        // Memory housekeeping
        void init_mm();
        void memmark(int,int);
        // Module directory
        void add_to_mdir(int);
        Word find_in_mdir(Word);
};
