/*
    (c) 2001 Soren Roug
 
    This file is part of Osnine.
 
    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    $Id: os9l1.cpp 60 2011-12-04 21:44:59Z roug $
*/
#include <cstdlib>
#include <cstdio>
#include <csignal>
#include <cstring>
using namespace std;
#include <ctype.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "mc6809.h"
#include "devdrvr.h"
#include "os9krnl.h"

#ifdef __unix
#include <unistd.h>
#endif

/**
 * Global variable containing the simulation class.
 */
os9 sys;

/**
 * Catch an interrupt. Usually from the keyboard.
 */
void interupt(int sig)
{
   exit(0);
}

void wakeitup(int sig)
{
}


static void settimer()
{
    struct itimerval tv;

    /* how long until the first signal is sent */
    tv.it_value.tv_sec = 0;
    tv.it_value.tv_usec = 100000;  /* = 0.1 second */
    /* interval between subsequent firings */
    tv.it_interval.tv_sec = 0;
    tv.it_interval.tv_usec = 100000;  /* = 0.1 second */
    setitimer (ITIMER_REAL, &tv, 0);
}

static void clocktick(int)
{
    (void)signal(SIGALRM, clocktick);
    sys.next_proc();
}


int main(int argc, char *argv[])
{
    char parm[256],*p;
    int i,j,size;

    (void)signal(SIGINT, interupt);
#if 0
//  (void)signal(SIGCHLD, wakeitup);
#endif
    // fixme: use sigaction
//  (void)signal(SIGALRM, clocktick);
//  settimer();

    // figure out how large the parameter area is
    size = 0;
    p = parm;
 
    for (i = 2; i < argc; i++) {
        j = strlen(argv[i]);
        strcpy(p, argv[i]);
        size += j;
        p += j;
        *(p++) = ' ';               // add a space between parameters
        size++;
    }
 
    if (size != 0) {
        *(p - 1) = 0x0d;
    } else {
        size++;
        *p = 0x0d;
    }

    sys.setdebugcalls(0); // 1 = print syscalls, 2 = print reads/writes
    sys.loadmodule((argc==1)?"shell":argv[1], parm);
    sys.run();

    return EXIT_SUCCESS;
}
