/*
    (c) 2001-2003 Soren Roug

    This file is part of Osnine.

    Osnine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Osnine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Osnine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    $Id: os9proc.cpp 60 2011-12-04 21:44:59Z roug $
*/

#include <cstdlib>
#include <cstdio>
#include <cstring>
using namespace std;
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "mc6809.h"
#include "devdrvr.h"
#include "os9krnl.h"
#include "errcodes.h"


/* ************************************
 * Process management
 ************************************** */

/**
 * Initialise process table.
 */
void os9::init_proc()
{
    // Set up some PIDs This process is hardcoded to PID #1
    f_all64();
    write_word(D_PrcDBT,x);
    write(y+p_ID, 1);
    pids[0] = getppid();
    pids[1] = getpid();
    pid_end = 2;
}

/**
 * Change to next process.
 * Look in the source for the PROCS command to see what pointers to change
 */
void os9::next_proc()
{
}
