//
//
//  usim.h
//
//  (C) R.P.Bellis 1994
//
//

#ifndef __usim_h__
#define __usim_h__

#include "machdep.h"
#include "typedefs.h"
#include "misc.h"

/**
 * Core microprocessor with no instruction set.
 */
class USim {

// Generic processor state
//protected:
public:

        int      halted;
        Byte        *memory;
        Byte        *port;

// Generic internal registers that we assume all CPUs have

        Word        ir; /**< Instruction register */
        Word        pc; /**< Program Counter */

// Generic read/write/execute functions
public:

    virtual Byte        read(Word offset);
    virtual Word        read_word(Word offset) = 0;
    virtual void        write(Word offset, Byte val);
    virtual void        write_word(Word offset, Word val) = 0;
    virtual Byte        fetch(void);
    virtual Word        fetch_word(void);
    virtual void        execute(void) = 0;

// Functions to start and stop the virtual processor
public:

    virtual void         run(void);
    virtual void         step(void);
    virtual void         halt(void);
    virtual void         reset(void) = 0;
    virtual void         status(void) = 0;
    virtual void         invalid(const char * = 0);

// Function to load the processor state
public:

        void         load_intelhex(const char *filename);
        void         load_srecord(const char *filename);

};

/**
 * Core microprocessor with no instruction set for big-endian CPUs.
 */
class USimMotorola : virtual public USim {

// Memory access functions taking target byte order into account
public:

    virtual Word        read_word(Word offset);
    virtual void        write_word(Word offset, Word val);

};

/**
 * Core microprocessor with no instruction set for little-endian CPUs.
 */
class USimIntel : virtual public USim {

// Memory access functions taking target byte order into account
public:

    virtual Word        read_word(Word offset);
    virtual void        write_word(Word offset, Word val);

};

#endif // __usim_h__
